% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_connect_to_cache.R
\name{tw_connect_to_cache}
\alias{tw_connect_to_cache}
\title{Return a connection to be used for caching}
\usage{
tw_connect_to_cache(connection = NULL, language = NULL)
}
\arguments{
\item{connection}{Defaults to NULL. If NULL, uses local SQLite database. If given, must be a connection object (see example)}

\item{language}{Defaults to language set with \code{tw_set_language()}; if not set, "en". Use "all_available" to keep all languages. For available language values, see https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}
}
\value{
A connection object.
}
\description{
Return a connection to be used for caching
}
\examples{
\donttest{
if (interactive()) {
  cache_connection <- DBI::dbConnect(
    RSQLite::SQLite(), # or e.g. odbc::odbc(),
    Driver =  ":memory:", # or e.g. "MariaDB",
    Host = "localhost",
    database = "example_db",
    UID = "example_user",
    PWD = "example_pwd"
  )
  tw_connect_to_cache(cache_connection)
}
}

}
