% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpcstats_fun.R
\name{vpcstats}
\alias{vpcstats}
\alias{vpcstats.tidyvpcobj}
\title{Compute VPC statistics}
\usage{
vpcstats(o, ...)

\method{vpcstats}{tidyvpcobj}(
  o,
  vpc.type = c("continuous", "categorical"),
  qpred = c(0.05, 0.5, 0.95),
  ...,
  conf.level = 0.95,
  quantile.type = 7
)
}
\arguments{
\item{o}{A \code{tidyvpcobj}.}

\item{...}{Other arguments to include.}

\item{vpc.type}{Character specifying type of VPC (e.g., \code{"continuous"} (Default) or \code{"categorical"}).}

\item{qpred}{Numeric vector of length 3 specifying quantile prediction interval. Only applicable for \code{vpc.type = "continuous"}.}

\item{conf.level}{Numeric specifying confidence level.}

\item{quantile.type}{Numeric indicating quantile type. See \code{\link[stats]{quantile}}.}
}
\value{
Updates \code{tidyvpcobj} with \code{stats} \code{data.table} object, which contains the following columns:
\itemize{
  \item \code{bin}: Resulting bin value as specified in \code{binning()} function
  \item \code{xbin}: Midpoint x-value of the observed data points in the bin as specified in \code{xbin} argument of \code{binning()} function
  \item \code{qname}: Quantiles specified in \code{qpred}.  Only returned if \code{vpc.type = "continuous"}
  \item \code{pname}: Categorical probability names. Only returned if \code{vpc.type = "categorical"}
  \item \code{y}: Observed y value for the specified quantile
  \item \code{lo}: Lower bound of specified confidence interval for y value in simulated data
  \item \code{md}: Median y value in simulated data
  \item \code{hi}: Upper bound of specified confidence interval for y value in simulated data
}
}
\description{
Compute prediction interval statistics for VPC.
}
\seealso{
\code{\link{observed}} \code{\link{simulated}} \code{\link{censoring}} \code{\link{stratify}} \code{\link{binning}} \code{\link{binless}} \code{\link{predcorrect}}
}
