% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_gtfs.R
\name{validate_gtfs}
\alias{validate_gtfs}
\title{Validate GTFS feed}
\usage{
validate_gtfs(gtfs_obj, files = NULL, warnings = TRUE)
}
\arguments{
\item{gtfs_obj}{gtfs object (i.e. a list of tables, not necessary a tidygtfs object)}

\item{files}{A character vector containing the text files to be validated
against the GTFS specification without the file extension (\code{txt} or \code{geojson}). If
\code{NULL} (the default), the provided GTFS feed is validated against all
possible GTFS text files.}

\item{warnings}{Whether to display warning messages (defaults to \code{TRUE}).}
}
\value{
A \code{validation_result} tibble containing the validation summary of all
possible fields from the specified files.
}
\description{
Validates the GTFS object against GTFS specifications and raises warnings if
required files/fields are not found. This function is called in \code{\link[=read_gtfs]{read_gtfs()}}.
}
\details{
Note that this function just checks if required files or fields are missing. There's no
validation for internal consistency (e.g. no departure times before arrival times or
calendar covering a reasonable period).
}
\section{Details}{

GTFS object's files and fields are validated against the GTFS specifications
as documented in \href{https://gtfs.org/documentation/schedule/reference/}{
GTFS Schedule Reference}:
\itemize{
\item GTFS feeds are considered valid if they include all required files
and fields. If a required file/field is missing the function (optionally)
raises a warning.
\item Optional files/fields are listed in the reference above but are not
required, thus no warning is raised if they are missing.
\item Extra files/fields are those who are not listed in the reference
above (either because they refer to a specific GTFS extension or due to
any other reason).
}
Note that some files (\code{calendar.txt}, \code{calendar_dates.txt} and
\code{feed_info.txt}) are conditionally required. This means that:
\itemize{
\item \code{calendar.txt} is initially set as a required file. If it's not
present, however, it becomes optional and \code{calendar_dates.txt}
(originally set as optional) becomes required.
\item \code{feed_info.txt} is initially set as an optional file. If
\code{translations.txt} is present, however, it becomes required.
}
}

\examples{
validate_gtfs(gtfs_duke)

\dontrun{
local_gtfs_path <- system.file("extdata", "nyc_subway.zip", package = "tidytransit")
gtfs <- read_gtfs(local_gtfs_path)
attr(gtfs, "validation_result")

gtfs$shapes <- NULL
validation_result <- validate_gtfs(gtfs)

# should raise a warning
gtfs$stop_times <- NULL
validation_result <- validate_gtfs(gtfs)
}
}
