% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joins.R
\name{filter_feed_by_date}
\alias{filter_feed_by_date}
\title{Filter a gtfs feed so that it only contains trips running on a given date}
\usage{
filter_feed_by_date(
  gtfs_obj,
  extract_date,
  min_departure_time = "00:00:00",
  max_arrival_time = "48:00:00"
)
}
\arguments{
\item{gtfs_obj}{a gtfs feed}

\item{extract_date}{date to extract trips from in YYYY-MM-DD format}

\item{min_departure_time}{The earliest departure time. Can be given as "HH:MM:SS",
hms object or numeric value in seconds.}

\item{max_arrival_time}{The latest arrival time. Can be given as "HH:MM:SS",
hms object or numeric value in seconds}
}
\value{
tidygtfs object with filtered tables
}
\description{
Only stop_times, stops, routes, services (in calendar and calendar_dates), shapes,
frequencies and transfers belonging to one of those trips are kept.
}
\seealso{
\code{\link{filter_stop_times}}, \code{\link{filter_feed_by_trips}},
\code{\link{filter_feed_by_trips}}, \code{\link{filter_feed_by_date}}
}
