% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest_sentence.R
\name{unnest_sentences}
\alias{unnest_sentences}
\alias{unnest_lines}
\alias{unnest_paragraphs}
\title{Wrapper around unnest_tokens for sentences, lines, and paragraphs}
\usage{
unnest_sentences(
  tbl,
  output,
  input,
  strip_punct = FALSE,
  format = c("text", "man", "latex", "html", "xml"),
  to_lower = TRUE,
  drop = TRUE,
  collapse = NULL,
  ...
)

unnest_lines(
  tbl,
  output,
  input,
  format = c("text", "man", "latex", "html", "xml"),
  to_lower = TRUE,
  drop = TRUE,
  collapse = NULL,
  ...
)

unnest_paragraphs(
  tbl,
  output,
  input,
  paragraph_break = "\\n\\n",
  format = c("text", "man", "latex", "html", "xml"),
  to_lower = TRUE,
  drop = TRUE,
  collapse = NULL,
  ...
)
}
\arguments{
\item{tbl}{A data frame}

\item{output}{Output column to be created as string or symbol.}

\item{input}{Input column that gets split as string or symbol.

The output/input arguments are passed by expression and support
\link[rlang]{quasiquotation}; you can unquote strings and symbols.}

\item{strip_punct}{Should punctuation be stripped?}

\item{format}{Either "text", "man", "latex", "html", or "xml". When the
format is "text", this function uses the tokenizers package. If not "text",
this uses the hunspell tokenizer, and can tokenize only by "word"}

\item{to_lower}{Whether to convert tokens to lowercase. If tokens include
URLS (such as with \code{token = "tweets"}), such converted URLs may no
longer be correct.}

\item{drop}{Whether original input column should get dropped. Ignored
if the original input and new output column have the same name.}

\item{collapse}{A character vector of variables to collapse text across,
or \code{NULL}.

For tokens like n-grams or sentences, text can be collapsed across rows
within variables specified by \code{collapse} before tokenization. At tidytext
0.2.7, the default behavior for \code{collapse = NULL} changed to be more
consistent. The new behavior is that text is \emph{not} collapsed for \code{NULL}.

Grouping data specifies variables to collapse across in the same way as
\code{collapse} but you \strong{cannot} use both the \code{collapse} argument and
grouped data. Collapsing applies mostly to \code{token} options of "ngrams",
"skip_ngrams", "sentences", "lines", "paragraphs", or "regex".}

\item{...}{Extra arguments passed on to \link[tokenizers]{tokenizers}}

\item{paragraph_break}{A string identifying the boundary between two
paragraphs.}
}
\description{
These functions are wrappers around \code{unnest_tokens( token = "sentences" )}
\code{unnest_tokens( token = "lines" )} and \code{unnest_tokens( token = "paragraphs" )}.
}
\examples{
library(dplyr)
library(janeaustenr)

d <- tibble(txt = prideprejudice)

d \%>\%
  unnest_sentences(word, txt)

}
\seealso{
\itemize{
\item \code{\link[=unnest_tokens]{unnest_tokens()}}
}
}
