% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_spatvector.R
\name{as_spatvector}
\alias{as_spatvector}
\alias{as_spatvector.data.frame}
\alias{as_spatvector.sf}
\alias{as_spatvector.sfc}
\alias{as_spatvector.SpatVector}
\title{Method for coercing objects to to SpatVector}
\usage{
as_spatvector(x, ...)

\method{as_spatvector}{data.frame}(x, ..., geom = c("lon", "lat"), crs = "")

\method{as_spatvector}{sf}(x, ...)

\method{as_spatvector}{sfc}(x, ...)

\method{as_spatvector}{SpatVector}(x, ...)
}
\arguments{
\item{x}{A tibble, data frame, sf or sfc object.}

\item{...}{additional arguments passed on to \code{\link[terra:vect]{terra::vect()}}.}

\item{geom}{character. The field name(s) with the geometry data. Either
two names for x and y coordinates of points, or a single name for a single
column with WKT geometries.}

\item{crs}{A crs on several formats (PROJ.4, WKT, EPSG code, ..) or
and spatial object from sf or terra that includes the target coordinate
reference system. See \code{\link[=pull_crs]{pull_crs()}}. See \strong{Details}.}
}
\value{
A SpatVector.
}
\description{
\code{as_spatvector()} turns an existing  object into a SpatVector. This is a
wrapper of \code{\link[terra:vect]{terra::vect()}} S4 method.
}
\details{
This function differs from \code{\link[terra:vect]{terra::vect()}} on the following:
\itemize{
\item geometries with \code{NA/""} values are removed prior to conversion
\item If \code{x} is a grouped data frame (see \code{\link[dplyr:group_by]{dplyr::group_by()}}) the grouping
vars are transferred and a "grouped" SpatVector is created (see
\code{\link[=group_by.SpatVector]{group_by.SpatVector()}}).
\item If no \code{crs} is provided and the tibble has been created with the method
\code{\link[=as_tibble.SpatVector]{as_tibble.SpatVector()}}, the \code{crs} is inferred from \code{attr(x, "crs")}.
\item Handles correctly the conversion of \code{EMPTY} geometries between \pkg{sf}
and \pkg{terra}.
}
}
\section{terra equivalent}{


\code{\link[terra:vect]{terra::vect()}}
}

\examples{
library(terra)

v <- vect(matrix(1:80, ncol = 2), crs = "epsg:3857")

v$cat <- sample(LETTERS[1:4], size = nrow(v), replace = TRUE)

v

# Create tibble
as_tbl <- as_tibble(v, geom = "WKT")

as_tbl

# From tibble
newvect <- as_spatvector(as_tbl, geom = "geometry", crs = "epsg:3857")
newvect

}
\seealso{
\code{\link[=pull_crs]{pull_crs()}}

Coercing objects:
\code{\link{as_coordinates}()},
\code{\link{as_sf}()},
\code{\link{as_spatraster}()},
\code{\link{as_tibble.Spat}},
\code{\link{fortify.Spat}}
}
\concept{coerce}
