% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R
\name{dt_mutate}
\alias{dt_mutate}
\title{Mutate}
\usage{
dt_mutate(.data, ..., by = NULL)
}
\arguments{
\item{.data}{A data.frame or data.table}

\item{...}{Columns to add/modify}

\item{by}{Optional: \code{list()} of bare column names to group by}
}
\description{
Add new columns or modify existing ones
}
\examples{
example_dt <- data.table::data.table(
  a = c(1,2,3),
  b = c(4,5,6),
  c = c("a","a","b"))

example_dt \%>\%
  dt_mutate(double_a = a * 2,
            a_plus_b = a + b)

example_dt \%>\%
  dt_mutate(double_a = a * 2,
            avg_a = mean(a),
            by = c)
}
