% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_stats.glm.r
\name{tidy_stats.glm}
\alias{tidy_stats.glm}
\title{Create a tidy stats data frame from a glm object}
\usage{
\method{tidy_stats}{glm}(model)
}
\arguments{
\item{model}{Output of \code{glm()}.}
}
\description{
\code{tidy_stats.glm} takes a glm object and converts the object to a tidy
stats data frame.
}
\examples{
# Get data
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
d.AD <- data.frame(treatment, outcome, counts)

# Run model
glm.D93 <- glm(counts ~ outcome + treatment, family = poisson())

# Tidy stats
tidy_stats(glm.D93)

}
