% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_data.r
\name{count_data}
\alias{count_data}
\title{Count the total of observations}
\usage{
count_data(data, ..., na.rm = TRUE)
}
\arguments{
\item{data}{A data frame.}

\item{...}{One or more unquoted (categorical) column names from the data
frame, separated by commas.}

\item{na.rm}{Logical. Should missing values (including NaN) be removed?}
}
\description{
\code{count_data} returns the number of observations for categorical
variables.
}
\details{
The data frame can be grouped using \strong{dplyr}'s \code{group_by}
so that the total of observations will be calculated for each group level.
}
\examples{
library(dplyr)

# 1 variable
count_data(cox, sex)

# 2 variables
count_data(cox, condition, sex)

# 1 variable, 1 group
cox \%>\%
  group_by(condition) \%>\%
  count_data(sex)

}
