% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyr_methods.R
\name{unite}
\alias{unite}
\alias{unite.Seurat}
\title{Unite multiple columns into one by pasting strings together}
\usage{
\method{unite}{Seurat}(data, col, ..., sep = "_", remove = TRUE, na.rm = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{col}{The name of the new column, as a string or symbol.

This argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote strings
and symbols). The name is captured from the expression with
\code{\link[rlang:defusing-advanced]{rlang::ensym()}} (note that this kind of interface where
symbols do not represent actual objects is now discouraged in the
tidyverse; we support it here for backward compatibility).}

\item{...}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> Columns to unite}

\item{sep}{Separator to use between values.}

\item{remove}{If \code{TRUE}, remove input columns from output data frame.}

\item{na.rm}{If \code{TRUE}, missing values will be removed prior to uniting
each value.}
}
\value{
`tidyseurat`
}
\description{
Convenience function to paste together multiple columns into one.
}
\examples{
data(pbmc_small)
pbmc_small |> unite(
  col="new_col", 
  c("orig.ident", "groups"))
    
}
\seealso{
\code{\link[tidyr:separate]{separate()}}, the complement.
}
