% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{left_join}
\alias{left_join}
\title{Left join datasets}
\usage{
left_join(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)
}
\arguments{
\item{x}{tbls to join. (See dplyr)}

\item{y}{tbls to join. (See dplyr)}

\item{by}{A character vector of variables to join by. (See dplyr)}

\item{copy}{If x and y are not from the same data source, and copy is TRUE, then y will be copied into the same src as x. (See dplyr)}

\item{suffix}{If there are non-joined duplicate variables in x and y, these suffixes will be added to the output to disambiguate them. Should be a character vector of length 2. (See dplyr)}

\item{...}{Data frames to combine (See dplyr)}
}
\value{
A tidyseurat object
}
\description{
Left join datasets
}
\examples{
`\%>\%` = magrittr::`\%>\%`

tt = pbmc_small \%>\% tidy
tt \%>\% left_join(tt \%>\% distinct(groups) \%>\% mutate(new_column = 1:2))

}
