% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{count}
\alias{count}
\title{Count observations by group}
\usage{
count(
  x,
  ...,
  wt = NULL,
  sort = FALSE,
  name = NULL,
  .drop = group_by_drop_default(x)
)
}
\arguments{
\item{x}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr).}

\item{...}{<[`data-masking`][dplyr_data_masking]> Variables to group by.}

\item{wt}{<[`data-masking`][dplyr_data_masking]> Frequency weights.
  Can be `NULL` or a variable:

  * If `NULL` (the default), counts the number of rows in each group.
  * If a variable, computes `sum(wt)` for each group.}

\item{sort}{If `TRUE`, will show the largest groups at the top.}

\item{name}{The name of the new column in the output.

  If omitted, it will default to `n`. If there's already a column called `n`,
  it will error, and require you to specify the name.}

\item{.drop}{For `count()`: if `FALSE` will include counts for empty groups
(i.e. for levels of factors that don't exist in the data). Deprecated in
`add_count()` since it didn't actually affect the output.}
}
\value{
An object of the same type as `.data`. `count()` and `add_count()`
group transiently, so the output has the same groups as the input.
}
\description{
`count()` lets you quickly count the unique values of one or more variables:
`df %>% count(a, b)` is roughly equivalent to
`df %>% group_by(a, b) %>% summarise(n = n())`.
`count()` is paired with `tally()`, a lower-level helper that is equivalent
to `df %>% summarise(n = n())`. Supply `wt` to perform weighted counts,
switching the summary from `n = n()` to `n = sum(wt)`.

`add_count()` are `add_tally()` are equivalents to `count()` and `tally()`
but use `mutate()` instead of `summarise()` so that they add a new column
with group-wise counts.
}
\examples{

`\%>\%` = magrittr::`\%>\%`
pbmc_small \%>\% tidy \%>\% count(groups)


}
