% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_ma.R
\name{geom_ma}
\alias{geom_ma}
\alias{geom_ma_}
\title{Plot moving averages}
\usage{
geom_ma(mapping = NULL, data = NULL, position = "identity",
  na.rm = TRUE, show.legend = NA, inherit.aes = TRUE, ma_fun = SMA,
  n = 20, wilder = FALSE, ratio = NULL, v = 1, wts = 1:n, ...)

geom_ma_(mapping = NULL, data = NULL, position = "identity",
  na.rm = TRUE, show.legend = NA, inherit.aes = TRUE,
  ma_fun = "SMA", n = 20, wilder = FALSE, ratio = NULL, v = 1,
  wts = 1:n, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}} or
\code{\link[ggplot2:aes_]{ggplot2::aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{ggplot2::fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{TRUE}, silently removes \code{NA} values, which
typically desired for moving averages.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{ggplot2::borders()}}.}

\item{ma_fun}{The function used to calculate the moving average. Seven options are
available including: SMA, EMA, WMA, DEMA, ZLEMA, VWMA, and EVWMA. The default is
\code{SMA}. See \code{\link[TTR:SMA]{TTR::SMA()}} for underlying functions.}

\item{n}{Number of periods to average over. Must be between 1 and
\code{nrow(x)}, inclusive.}

\item{wilder}{logical; if \code{TRUE}, a Welles Wilder type EMA will be
calculated; see notes.}

\item{ratio}{A smoothing/decay ratio.  \code{ratio} overrides \code{wilder}
in \code{EMA}, and provides additional smoothing in \code{VMA}.}

\item{v}{The 'volume factor' (a number in [0,1]).  See Notes.}

\item{wts}{Vector of weights.  Length of \code{wts} vector must equal the
length of \code{x}, or \code{n} (the default).}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{ggplot2::layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
The underlying moving average functions used are specified in \code{\link[TTR:SMA]{TTR::SMA()}}
from the TTR package. Use \code{\link[=coord_x_date]{coord_x_date()}} to zoom into specific plot regions.
The following moving averages are available:
\itemize{
\item \strong{\href{http://www.investopedia.com/terms/s/sma.asp}{Simple moving averages (SMA)}}:
Rolling mean over a period defined by \code{n}.
\item \strong{\href{http://www.investopedia.com/terms/e/ema.asp}{Exponential moving averages (EMA)}}: Includes
exponentially-weighted mean that gives more weight to recent observations.
Uses \code{wilder} and \code{ratio} args.
\item \strong{\href{http://www.investopedia.com/ask/answers/071414/whats-difference-between-moving-average-and-weighted-moving-average.asp}{Weighted moving averages (WMA)}}:
Uses a set of weights, \code{wts}, to weight observations in the moving average.
\item \strong{\href{http://www.investopedia.com/articles/trading/10/double-exponential-moving-average.asp}{Double exponential moving averages (DEMA)}}:
Uses \code{v} volume factor, \code{wilder} and \code{ratio} args.
\item \strong{\href{https://en.wikipedia.org/wiki/Zero_lag_exponential_moving_average}{Zero-lag exponential moving averages (ZLEMA)}}:
Uses \code{wilder} and \code{ratio} args.
\item \strong{\href{http://www.investopedia.com/articles/trading/11/trading-with-vwap-mvwap.asp}{Volume-weighted moving averages (VWMA)}}:
Requires \code{volume} aesthetic.
\item \strong{\href{http://www.motivewave.com/studies/elastic_volume_weighted_moving_average.htm}{Elastic, volume-weighted moving averages (EVWMA)}}:
Requires \code{volume} aesthetic.
}
}
\section{Aesthetics}{

The following aesthetics are understood (required are in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \code{volume}, Required for VWMA and EVWMA
\item \code{alpha}
\item \code{colour}
\item \code{group}
\item \code{linetype}
\item \code{size}
}
}

\examples{
# Load libraries
library(tidyquant)

AAPL <- tq_get("AAPL")

# SMA
AAPL \%>\%
    ggplot(aes(x = date, y = adjusted)) +
    geom_line() +                         # Plot stock price
    geom_ma(ma_fun = SMA, n = 50) +                 # Plot 50-day SMA
    geom_ma(ma_fun = SMA, n = 200, color = "red") + # Plot 200-day SMA
    coord_x_date(xlim = c(today() - weeks(12), today()),
               ylim = c(100, 130))                     # Zoom in

# EVWMA
AAPL \%>\%
    ggplot(aes(x = date, y = adjusted)) +
    geom_line() +                                                   # Plot stock price
    geom_ma(aes(volume = volume), ma_fun = EVWMA, n = 50) +   # Plot 50-day EVWMA
    coord_x_date(xlim = c(today() - weeks(12), today()),
               ylim = c(100, 130))                                  # Zoom in
}
\seealso{
See individual modeling functions for underlying parameters:
\itemize{
\item \code{\link[TTR:SMA]{TTR::SMA()}} for simple moving averages
\item \code{\link[TTR:EMA]{TTR::EMA()}} for exponential moving averages
\item \code{\link[TTR:WMA]{TTR::WMA()}} for weighted moving averages
\item \code{\link[TTR:DEMA]{TTR::DEMA()}} for double exponential moving averages
\item \code{\link[TTR:ZLEMA]{TTR::ZLEMA()}} for zero-lag exponential moving averages
\item \code{\link[TTR:VWMA]{TTR::VWMA()}} for volume-weighted moving averages
\item \code{\link[TTR:EVWMA]{TTR::EVWMA()}} for elastic, volume-weighted moving averages
\item \code{\link[=coord_x_date]{coord_x_date()}} for zooming into specific regions of a plot
}
}
