% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-column.R
\name{tidypredict_to_column}
\alias{tidypredict_to_column}
\title{Adds the prediction columns to a piped command set}
\usage{
tidypredict_to_column(df, model, add_interval = FALSE, interval = 0.95,
  vars = c("fit", "upper", "lower"))
}
\arguments{
\item{df}{A data.frame or tibble}

\item{model}{An R model or a parsed model inside a data frame}

\item{add_interval}{Switch that indicates if the prediction interval columns should be added. Defaults
to FALSE}

\item{interval}{The prediction interval, defaults to 0.95. It is ignored if add_interval is set to
FALSE}

\item{vars}{The name of the variables that this function will produce. It defaults to "fit", "upper", and "lower".}
}
\description{
Adds a new column with the results form tidypredict_fit() to a piped command set.
If add_interval is set to TRUE, then it will add two additional columns, one
for the lower and another for the upper prediction interval bounds.
}
\examples{
library(dplyr)
df <- mutate(mtcars, cyl = paste0("cyl", cyl))
model <- lm(mpg ~ wt + cyl * disp, offset = am, data = df)

df \%>\%
  tidypredict_to_column(model, add_interval = TRUE)
}
