% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perf_mod.R
\name{perf_mod}
\alias{perf_mod}
\alias{perf_mod.rset}
\alias{perf_mod.vfold_cv}
\alias{perf_mod.resamples}
\alias{perf_mod.data.frame}
\title{Bayesian Analysis of Resampling Statistics}
\usage{
perf_mod(object, ...)

\method{perf_mod}{rset}(object, transform = no_trans, hetero_var = FALSE,
  ...)

\method{perf_mod}{vfold_cv}(object, transform = no_trans,
  hetero_var = FALSE, ...)

\method{perf_mod}{resamples}(object, transform = no_trans,
  hetero_var = FALSE, metric = object$metrics[1], ...)

\method{perf_mod}{data.frame}(object, transform = no_trans,
  hetero_var = FALSE, ...)
}
\arguments{
\item{object}{A data frame or an \code{rset} object (such as
\code{\link[rsample:vfold_cv]{rsample::vfold_cv()}}) containing the \code{id} column(s) and at least
two numeric columns of model performance statistics (e.g.
accuracy). Additionally, an object from \code{caret::resamples}
can be used.}

\item{...}{Additonal arguments to pass to \code{\link[rstanarm:stan_glmer]{rstanarm::stan_glmer()}}
such as \code{verbose}, \code{prior}, \code{seed}, \code{family}, etc.}

\item{transform}{An named list of transformation and inverse
transformation fuctions. See \code{\link[=logit_trans]{logit_trans()}} as an example.}

\item{hetero_var}{A logical; if \code{TRUE}, then different
variances are estimated for each model group. Otherwise, the
same variance is used for each group. Estimating heterogeneous
variances may slow or prevent convergence.}

\item{metric}{A single character value for the statstic from
the \code{resamples} object that should be analyzed.}
}
\value{
An object of class \code{perf_mod}.
}
\description{
Bayesian analysis used here to answer the question: "when
looking at resampling results, are the differences between
models 'real?'" To answer this, a model can be created were the
\emph{outcome} is the resampling statistics (e.g. accuracy or RMSE).
These values are explained by the model types. In doing this, we
can get parameter estimates for each model's affect on
performance and make statistical (and practical) comparisons
between models.
}
\details{
These functions can be used to process and analyze
matched resampling statistics from different models using a
Bayesian generalized linear model with effects for the model and
the resamples.

By default, a generalized linear model with Gaussian error and
an identity link is fit to the data and has terms for the
predictive model grouping variable. In this way, the performance
metrics can be compared between models.

Additionally, random effect terms are also used. For most
resampling methods (except repeated \emph{V}-fold cross-validation),
a simple random intercept model its used with an exchangeable
(i.e. compound-symmetric) variance structure. In the case of
repeated cross-validation, two random intercept terms are used;
one for the repeat and another for the fold within repeat. These
also have exchangeable correlation structures.

The above model specification assumes that the variance in the
performance metrics is the same across models. However, this is
unlikely to be true in some cases. For example, for simple
binomial accuracy, it well know that the variance is highest
when the accuracy is near 50 percent. When the argument
\code{hetero_var = TRUE}, the variance structure uses random
intercepts for each model term. This may produce more realistic
posterior distributions but may take more time to converge.

Also, as shown in the package vignettes, the Gaussian assumption
make be unrealistic. In this case, there are at least two
approaches that can be used. First, the outcome statistics can
be transformed prior to fitting the model. For example, for
accuracy, the logit transformation can be used to convert the
outcome values to be on the real line and a model is fit to
these data. Once the posterior distributions are computed, the
inverse transformation can be used to put them back into the
original units. The \code{transform} argument can be used to do this.

The second approach would be to use a different error
distribution from the exponential family. For RMSE values, the
Gamma distribution may produce better results at the expense of
model computational complexity. This can be achieved by passing
the \code{family} argument to \code{perf_mod} as one might with the
\code{glm} function.
}
\examples{
# Example objects from the "Getting Started" vignette at
#  https://topepo.github.io/tidyposterior/articles/Getting_Started.html

file <- system.file("examples", "roc_model.RData", package = "tidyposterior")
load(file)

roc_model

# Summary method shows the underlying `stan` model
summary(roc_model)
}
