% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{flip_plot}
\alias{flip_plot}
\title{Flip x and y-axis}
\usage{
flip_plot(plot, ...)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{...}{Arguments passed on to \code{ggplot2::coord_flip()}.}
}
\value{
A \code{tidyplot} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

This function is superseded because in many cases, \code{flip_plot()} can easily
be replaced by swapping the \code{x} and \code{y} axis. Some plot components additionally
require to set the \code{orientation} argument to \code{"y"}.
}
\examples{
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_data_points() \%>\%
  add_mean_bar(alpha = 0.4) \%>\%
  add_sem_errorbar() \%>\%
  flip_plot()

energy \%>\%
  tidyplot(x = year, y = power, color = energy_type) \%>\%
  add_barstack_absolute() \%>\%
  flip_plot()

# Better solutions without `flip_plot()`
study \%>\%
  tidyplot(x = score, y = treatment, color = treatment) \%>\%
  add_data_points() \%>\%
  add_mean_bar(alpha = 0.4) \%>\%
  add_sem_errorbar()

energy \%>\%
  tidyplot(x = power, y = year, color = energy_type) \%>\%
  add_barstack_absolute(orientation = "y")

}
