% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm_message.R
\name{df_llm_message}
\alias{df_llm_message}
\title{Convert a Data Frame to an LLMMessage Object}
\usage{
df_llm_message(.df)
}
\arguments{
\item{.df}{A data frame with at least two rows and columns \code{role} and \code{content}.
The \code{role} column should contain "user", "assistant", or "system". The \code{content} column should contain the corresponding message text.}
}
\value{
An \code{LLMMessage} object representing the structured conversation.
}
\description{
This function converts a data frame into an \code{LLMMessage} object representing a conversation history.
The data frame must have specific columns (\code{role} and \code{content}), with each row representing a message.
}
\seealso{
\code{\link[=llm_message]{llm_message()}}

Other Message Creation Utilities: 
\code{\link{llm_message}()}
}
\concept{Message Creation Utilities}
