% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyllm_schema.R
\name{tidyllm_schema}
\alias{tidyllm_schema}
\title{Create a JSON schema for structured outputs}
\usage{
tidyllm_schema(name = "tidyllm_schema", ...)
}
\arguments{
\item{name}{A character vector specifying the schema name. This serves as an identifier for the schema (Default: "tidyllm_schema").}

\item{...}{Named arguments where each name represents a field in the schema and each value specifies the type. Supported types include R data types:
\itemize{
\item "character": Represents a charcater type
\item "string": Allowed shorthand for charachter type
\item "factor(...)": A string with specific allowable values, represented as enum in JSON. Specify options as factor(option1, option2).
\item "logical": Represents a boolean.
\item "numeric": Represents a number.
\item "type[]": Appending [] allows for vector of a given type, e.g., "character[]".
}}
}
\value{
A list representing the JSON schema with the specified fields and types, suitable for passing to openai()'s .json_schema parameter.
}
\description{
This function creates a JSON schema suitable for use with the API functions in tidyllm.
}
\details{
The tidyllm_schema() function is designed to make defining JSON schemas for tidyllm more concise and user-friendly. It maps R-like types to JSON schema types and validates inputs to enforce tidy data principles. Nested structures are not allowed to maintain compatibility with tidy data conventions.
}
\note{
Factor types (factor(...)) are treated as enumerations in JSON and are limited to a set of allowable string values. Arrays of a given type can be specified by appending [] to the type.
}
\examples{
\dontrun{
# Define a schema with tidy data principles
json_schema <- tidyllm_schema(
  name = "DocumentAnalysisSchema",
  Title = "character",
  Authors = "character[]",
  SuggestedFilename = "character",
  Type = "factor(Policy, Research)",
  Answer_Q1 = "character",
  Answer_Q2 = "character",
  Answer_Q3 = "character",
  Answer_Q4 = "character",
  KeyCitations = "character[]"
)

# Pass the schema to openai()
result <- openai(
  .llm = msg,
  .json_schema = json_schema
)
}
}
