% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groq.R
\name{groq_transcribe}
\alias{groq_transcribe}
\title{Transcribe an Audio File Using Groq transcription API}
\usage{
groq_transcribe(
  .audio_file,
  .model = "whisper-large-v3",
  .language = NULL,
  .prompt = NULL,
  .temperature = 0,
  .api_url = "https://api.groq.com/openai/v1/audio/transcriptions",
  .dry_run = FALSE,
  .verbose = FALSE,
  .max_tries = 3
)
}
\arguments{
\item{.audio_file}{The path to the audio file (required). Supported formats include flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.}

\item{.model}{The model to use for transcription (default: "whisper-large-v3").}

\item{.language}{The language of the input audio, in ISO-639-1 format (optional).}

\item{.prompt}{A prompt to guide the transcription style. It should match the audio language (optional).}

\item{.temperature}{Sampling temperature, between 0 and 1, with higher values producing more randomness (default: 0).}

\item{.api_url}{Base URL for the API (default: "https://api.groq.com/openai/v1/audio/transcriptions").}

\item{.dry_run}{Logical; if TRUE, performs a dry run and returns the request object without making the API call (default: FALSE).}

\item{.verbose}{Logical; if TRUE, rate limiting info is displayed after the API request (default: FALSE).}

\item{.max_tries}{Maximum retries to peform request}
}
\value{
A character vector containing the transcription.
}
\description{
This function reads an audio file and sends it to the Groq transcription API for transcription.
}
\examples{
\dontrun{
# Basic usage
groq_transcribe(.audio_file = "example.mp3")
}

}
