% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/json_lengths.r
\name{json_lengths}
\alias{json_lengths}
\title{Add a column that contains the length of the JSON data}
\usage{
json_lengths(x, column.name = "length")
}
\arguments{
\item{x}{a tbl_json object}

\item{column.name}{the name to specify for the length column}
}
\value{
a tbl_json object with column.name column that tells the length
}
\description{
When investigating JSON data it can be helpful to identify the lengths of the
JSON objects or arrays, especialy when they are 'ragged' across documents. The
json_lengths() function adds a column (default name "length") that contains
the 'length' of the JSON associated with each row. For objects, this will
be equal to the number of keys. For arrays, this will be equal to the length
of the array. All scalar values will be of length 1.
}
\examples{
library(magrittr)  # for \%>\%
c('[1, 2, 3]', '{"k1": 1, "k2": 2}', '1', {}) \%>\% json_lengths
}

