% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution-fit.R
\name{distribution_fit}
\alias{distribution_fit}
\alias{dist_gamma}
\alias{dist_glo}
\alias{dist_gev}
\alias{dist_pe3}
\title{The distribution fit module}
\usage{
distribution_fit(data, ...)

dist_gamma(var, method = "lmoms", .n_boot = 1, .boot_seed = 123)

dist_glo(var, method = "lmoms", .n_boot = 1, .boot_seed = 123)

dist_gev(var, method = "lmoms", .n_boot = 1, .boot_seed = 123)

dist_pe3(var, method = "lmoms", .n_boot = 1, .boot_seed = 123)
}
\arguments{
\item{data}{an index table object}

\item{...}{a distribution fit object, currently implemented are
\code{dist_gamma()}, \code{dist_glo()}, \code{dist_gev()}, and
\code{dist_pe3()}}

\item{var}{used in \code{dist_*()} functions, the variable to fit}

\item{method}{used in \code{dist_*()} functions, the fitting method,
currently support "lmoms" for L-moment fit}

\item{.n_boot}{the number of bootstrap replicate, default to 1}

\item{.boot_seed}{the seed to generate bootstrap replicate, default to 123}
}
\value{
an index table object
}
\description{
This module fits a distribution to the variable of interest. Currently
implemented distributions are: gamma, \code{dist_gamma()},
generalized logistic, \code{dist_glo()}, generalized extreme value,
\code{dist_gev()}, and Pearson Type III, \code{dist_pe3()}
}
\examples{
library(dplyr)
library(lmomco)
tenterfield |>
  mutate(month = lubridate::month(ym)) |>
  init(id = id, time = ym, group = month) |>
  temporal_aggregate(.agg = temporal_rolling_window(prcp, scale = 12)) |>
  distribution_fit(.fit = dist_gamma(.agg, method = "lmoms"))
}
