% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_rows.R
\name{drop_rows_all_na}
\alias{drop_rows_all_na}
\alias{filter_all_na}
\alias{drop_rows_any_na}
\alias{filter_any_na}
\title{drop_rows_all_na, drop_rows_any_na}
\usage{
drop_rows_all_na(.tbl)

filter_all_na(.tbl)

drop_rows_any_na(.tbl)

filter_any_na(.tbl)
}
\arguments{
\item{.tbl}{data-like object}
}
\value{
An object of the same class as \code{.tbl} with rows containing all
\code{NA} values removed
}
\description{
Drop rows of a table whose values are all NA
}
\details{
\code{na_drop_rows} removes all rows whose only values are NA. It works for all
table-like objects.
}
\examples{

  data(iris)
  
  .tbl <- iris[1:5,]
  .tbl[1:2,] <- NA
  .tbl[3,1] <- NA
  .tbl
  
  filter_all_na(.tbl) 
  filter_any_na(.tbl)
  
  drop_rows_all_na(.tbl)
  drop_rows_any_na(.tbl)
  
}
\seealso{
\itemize{
\item \code{\link[dplyr:filter]{dplyr::filter()}}
}
}
