% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_cfg.R
\name{SLEnsemble_cfg}
\alias{SLEnsemble_cfg}
\title{Configuration for a SuperLearner Ensemble}
\description{
\code{SLEnsemble_cfg} is a configuration class for estimation of a model
using an ensemble of models using \code{SuperLearner}.
}
\examples{
SLEnsemble_cfg$new(
learner_cfgs = list(SLLearner_cfg$new("SL.glm"), SLLearner_cfg$new("SL.gam"))
)

## ------------------------------------------------
## Method `SLEnsemble_cfg$new`
## ------------------------------------------------

SLEnsemble_cfg$new(
learner_cfgs = list(SLLearner_cfg$new("SL.glm"), SLLearner_cfg$new("SL.gam"))
)
}
\section{Super class}{
\code{\link[tidyhte:Model_cfg]{tidyhte::Model_cfg}} -> \code{SLEnsemble_cfg}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{cvControl}}{A list of parameters for controlling the
cross-validation used in SuperLearner.}

\item{\code{SL.library}}{A vector of the names of learners to
include in the SuperLearner ensemble.}

\item{\code{SL.env}}{An environment containing all of the programmatically
generated learners to be included
in the SuperLearner ensemble.}

\item{\code{family}}{\code{stats::family} object to determine how SuperLearner
should be fitted.}

\item{\code{model_class}}{The class of the model, required for all classes
which inherit from \code{Model_cfg}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SLEnsemble_cfg-new}{\code{SLEnsemble_cfg$new()}}
\item \href{#method-SLEnsemble_cfg-add_sublearner}{\code{SLEnsemble_cfg$add_sublearner()}}
\item \href{#method-SLEnsemble_cfg-clone}{\code{SLEnsemble_cfg$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SLEnsemble_cfg-new"></a>}}
\if{latex}{\out{\hypertarget{method-SLEnsemble_cfg-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{SLEnsemble_cfg} object with specified settings.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLEnsemble_cfg$new(
  cvControl = NULL,
  learner_cfgs = NULL,
  family = stats::gaussian()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cvControl}}{A list of parameters for controlling the
cross-validation used in SuperLearner.
For more details, see \code{SuperLearner::SuperLearner.CV.control}.}

\item{\code{learner_cfgs}}{A list of \code{SLLearner_cfg} objects.}

\item{\code{family}}{\code{stats::family} object to determine how SuperLearner should be fitted.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{SLEnsemble_cfg} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{SLEnsemble_cfg$new(
learner_cfgs = list(SLLearner_cfg$new("SL.glm"), SLLearner_cfg$new("SL.gam"))
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SLEnsemble_cfg-add_sublearner"></a>}}
\if{latex}{\out{\hypertarget{method-SLEnsemble_cfg-add_sublearner}{}}}
\subsection{Method \code{add_sublearner()}}{
Adds a model (or class of models) to the SuperLearner ensemble.
If hyperparameter values are specified, this method will
add a learner for every element in the cross-product of provided
hyperparameter values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLEnsemble_cfg$add_sublearner(learner_name, hps = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{learner_name}}{Possible values
use \code{SuperLearner} naming conventions. A full list is available
with \code{SuperLearner::listWrappers("SL")}}

\item{\code{hps}}{A named list of hyper-parameters. Every element of the
cross-product of these hyper-parameters will be included in the
ensemble.
cfg <- SLEnsemble_cfg$new(
learner_cfgs = list(SLLearner_cfg$new("SL.glm"))
)
cfg <- cfg$add_sublearner("SL.gam", list(deg.gam = c(2, 3)))}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SLEnsemble_cfg-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SLEnsemble_cfg-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLEnsemble_cfg$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
