% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setops.R
\name{intersect_dt}
\alias{intersect_dt}
\alias{union_dt}
\alias{setdiff_dt}
\alias{setequal_dt}
\title{Set operations for data frames}
\usage{
intersect_dt(x, y, all = FALSE)

union_dt(x, y, all = FALSE)

setdiff_dt(x, y, all = FALSE)

setequal_dt(x, y, all = TRUE)
}
\arguments{
\item{x}{A data.frame}

\item{y}{A data.frame}

\item{all}{Logical. When \code{FALSE} (default),
removes duplicate rows on the result.}
}
\value{
A data.table
}
\description{
Wrappers of set operations in \pkg{data.table}.
Only difference is it could be applied to non-data.table data frames by
recognizing and coercing them to data.table automatically.
}
\examples{

x = iris[c(2,3,3,4),]
x2 = iris[2:4,]
y = iris[c(3:5),]

intersect_dt(x, y)            # intersect
intersect_dt(x, y, all=TRUE)  # intersect all
setdiff_dt(x, y)              # except
setdiff_dt(x, y, all=TRUE)    # except all
union_dt(x, y)                # union
union_dt(x, y, all=TRUE)      # union all
setequal_dt(x, x2, all=FALSE) # setequal
setequal_dt(x, x2)            # setequal all

}
\seealso{
\code{\link[data.table]{setops}}
}
