% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_dt.R
\name{summarise_dt}
\alias{summarise_dt}
\alias{summarize_dt}
\title{Summarise columns to single values}
\usage{
summarise_dt(data, ..., by = NULL)

summarize_dt(data, ..., by = NULL)
}
\arguments{
\item{data}{data.frame}

\item{...}{List of variables or name-value pairs of summary/modifications
functions.}

\item{by}{unquoted name of grouping variable of list of unquoted names of
grouping variables. For details see \link[data.table]{data.table}}
}
\value{
data.table
}
\description{
Analogous function for \code{summarise}  in \pkg{dplyr}.
}
\examples{
iris \%>\% summarise_dt(avg = mean(Sepal.Length))
iris \%>\% summarise_dt(avg = mean(Sepal.Length),by = Species)
mtcars \%>\% summarise_dt(avg = mean(hp),by = .(cyl,vs))

# the data.table way
mtcars \%>\% summarise_dt(cyl_n = .N, by = .(cyl, vs)) # `.`` is short for list



}
\seealso{
\code{\link[dplyr]{summarise}}
}
