% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.mrmr.R
\name{.fit.mrmr}
\alias{.fit.mrmr}
\title{Minimum redundancy, maximum relevance feature selection for \code{tidyfit}}
\usage{
\method{.fit}{mrmr}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Selects features for continuous or (ordered) factor data using MRMR on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}} and \code{\link{classify}}.
}
\details{
\strong{Hyperparameters:}

\emph{None. Cross validation not applicable.}

\strong{Important method arguments (passed to \code{\link{m}})}
\itemize{
\item feature_count (\emph{number of features to select})
\item solution_count (\emph{ensemble size})
}

The MRMR algorithm is estimated using the \code{mRMRe::mRMR.ensemble} function. See \code{?mRMR.ensemble} for more details.

\strong{Implementation}

Use with \code{\link{regress}} for regression problems and with \code{\link{classify}} for classification problems. The selected features can be obtained using \code{coef}.

The MRMR objects have no \code{predict} and related methods.
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns
data <- dplyr::filter(data, Industry == "HiTec")
data <- dplyr::select(data, SMB, HML, RMW, CMA, Return)

\dontrun{
fit <- m("mrmr", Return ~ ., data, feature_count = 2)

# Retrieve selected features
coef(fit)
}

}
\references{
De Jay N, Papillon-Cavanagh S, Olsen C, Bontempi G and Haibe-Kains B (2012).
\emph{mRMRe: an R package for parallelized mRMR ensemble feature selection}.
}
\seealso{
\code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
