% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{z_scale}
\alias{z_scale}
\title{Z-standardize numeric, continuous variables}
\usage{
z_scale(data, ..., name = NULL, overwrite = FALSE)
}
\arguments{
\item{data}{A \link[tibble:tibble-package]{tibble} or a \link{tdcmm} model.}

\item{...}{Numeric variables to be z-standardized. If none are provided, all numeric columns will be z-standardized.}

\item{name}{Optional name for the new z-standardized variable when a single variable is provided. By default, the name will be the original variable name suffixed with \verb{_z}.}

\item{overwrite}{Logical. If \code{TRUE}, it overwrites the original variable(s) with the z-standardized values. If \code{FALSE} (default), a new variable(s) is created.}
}
\value{
A \link{tdcmm} model with the z-standardized variable(s).
}
\description{
This function z-standardizes the specified numeric columns or all numeric columns
if none are specified. A z-standardized scale centers at a mean of 0.0 and has
a standard deviation of 1.0, making it comparable to other z-standardized distributions.
}
\examples{
WoJ \%>\% z_scale(autonomy_emphasis)
WoJ \%>\% z_scale(autonomy_emphasis, name = "my_zstdized_variable")
WoJ \%>\%
  z_scale(autonomy_emphasis) \%>\%
  tab_frequencies(autonomy_emphasis, autonomy_emphasis_z)
}
\seealso{
Other scaling: 
\code{\link{categorize_scale}()},
\code{\link{center_scale}()},
\code{\link{dummify_scale}()},
\code{\link{minmax_scale}()},
\code{\link{recode_cat_scale}()},
\code{\link{reverse_scale}()},
\code{\link{setna_scale}()}
}
\concept{scaling}
