% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-seg_basket.R
\name{plot_best_chromosome}
\alias{plot_best_chromosome}
\alias{plot_cpt_repeated}
\title{Diagnostic plots for \code{seg_basket} objects}
\usage{
plot_best_chromosome(x)

plot_cpt_repeated(x, i = nrow(x$basket))
}
\arguments{
\item{x}{A \code{\link[=seg_basket]{seg_basket()}} object}

\item{i}{index of basket to show}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object
}
\description{
Diagnostic plots for \code{seg_basket} objects
}
\details{
\code{\link[=seg_basket]{seg_basket()}} objects contain baskets of candidate changepoint sets.

\code{\link[=plot_best_chromosome]{plot_best_chromosome()}} shows how the size of the candidate changepoint
sets change across the generations of evolution.

\code{\link[=plot_cpt_repeated]{plot_cpt_repeated()}} shows how frequently individual observations appear in
the best candidate changepoint sets in each generation.
}
\examples{
\donttest{
# Segment a time series using Coen's algorithm
x <- segment(DataCPSim, method = "coen", num_generations = 3)

# Plot the size of the sets during the evolution
x |>
  as.segmenter() |>
  plot_best_chromosome()
}
\donttest{
# Segment a time series using Coen's algorithm
x <- segment(DataCPSim, method = "coen", num_generations = 3)

# Plot overall frequency of appearance of changepoints
plot_cpt_repeated(x$segmenter)

# Plot frequency of appearance only up to a specific generation
plot_cpt_repeated(x$segmenter, 5)
}
}
