% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/value_attribute_classifiers.R
\name{sample_based_classifier}
\alias{sample_based_classifier}
\alias{sample_based_classifier.default}
\alias{sample_based_classifier.cell_df}
\title{Sample Based Value/Attribute Classifier}
\usage{
sample_based_classifier(
  x,
  ...,
  value_sample,
  attribute_sample,
  empty_sample,
  partial_match = FALSE,
  case_insensitive = FALSE,
  verbose = FALSE
)

\method{sample_based_classifier}{default}(
  x,
  ...,
  value_sample = NULL,
  attribute_sample = NULL,
  empty_sample = NULL,
  partial_match = FALSE,
  case_insensitive = FALSE,
  verbose = FALSE
)

\method{sample_based_classifier}{cell_df}(
  x,
  ...,
  value_sample,
  attribute_sample,
  empty_sample,
  partial_match = FALSE,
  case_insensitive = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{x}{Either a \code{\link[=cell_df-class]{cell_df}} or leave blank for function output
(required by \code{\link[=value_attribute_classify]{value_attribute_classify}})}

\item{value_sample}{Sample of values (an optional \code{character} vector)}

\item{attribute_sample}{Sample of attribute (an optional \code{character} vector)}

\item{empty_sample}{Sample of empty cells (an optional \code{character} vector)}

\item{partial_match}{Logical scalar indicating whether partial match is allowed. (Default \code{FALSE})}

\item{case_insensitive}{Logical scalar indicating whether match will be case insensitive. (Default \code{FALSE})}

\item{verbose}{Logical scalar for printing discovered cells (which gets new type by this rule)}
}
\description{
Sample Based Value/Attribute Classifier
}
\seealso{
\link[=value_attribute_classify]{value_attribute_classify}
}
\keyword{internal}
