% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mx_mixture.R
\name{mx_profiles}
\alias{mx_profiles}
\title{Estimate latent profile analyses using OpenMx}
\usage{
mx_profiles(
  data = NULL,
  classes = 1L,
  variances = "equal",
  covariances = "zero",
  run = TRUE,
  expand_grid = FALSE,
  ...
)
}
\arguments{
\item{data}{The data.frame to be used for model fitting.}

\item{classes}{A vector of integers, indicating which class solutions to
generate. Defaults to 1L. E.g., \code{classes = 1:6},}

\item{variances}{Character vector. Specifies which variance components to
estimate. Defaults to "equal" (constrain variances across classes); the
other option is "varying" (estimate variances freely across classes). Each
element of this vector refers to one of the models you wish to run.}

\item{covariances}{Character vector. Specifies which covariance components to
estimate. Defaults to "zero" (covariances constrained to zero; this
corresponds
to an assumption of conditional independence of the indicators); other
options are "equal" (covariances between items constrained to be equal across
classes), and "varying" (free covariances across classes).}

\item{run}{Logical, whether or not to run the model. If \code{run = TRUE},
the function calls \code{\link{mixture_starts}} and \code{\link{run_mx}}.}

\item{expand_grid}{Logical, whether or not to estimate all possible combinations of the \code{variances} and \code{covariances} arguments. Defaults to \code{FALSE}.}

\item{...}{Additional arguments, passed to functions.}
}
\value{
Returns an \code{\link[OpenMx]{mxModel}}.
}
\description{
This function is a wrapper around \code{\link{mx_mixture}} to simplify the
specification of latent profile models, also known as finite mixture models.
By default, the function estimates free means for all observed variables
across classes.
}
\examples{
\dontrun{
data("empathy")
df <- empathy[1:6]
mx_profiles(data = df,
            classes = 2) -> res
}
}
\references{
Van Lissa, C. J., Garnier-Villarreal, M., & Anadria, D. (2023).
Recommended Practices in Latent Class Analysis using the Open-Source
R-Package tidySEM. Structural Equation Modeling.
\doi{10.1080/10705511.2023.2250920}
}
\keyword{mixture}
\keyword{models}
\keyword{openmx}
