% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micro_otu.R
\name{micro_otu}
\alias{micro_otu}
\title{Extract OTU table from tidyMicro set}
\usage{
micro_otu(micro_set, table, taxa_info = cts)
}
\arguments{
\item{micro_set}{A tidy_micro data set}

\item{table}{OTU table of interest}

\item{taxa_info}{The taxa info to pull}
}
\value{
A tibble
}
\description{
A simple wrapper to extract an OTU table from a tidyMicro set
}
\examples{
data(mrsa_gen); data(mrsa_clin)

## Creating tidyMicro set
set <- tidy_micro(otu_tabs = mrsa_gen, tab_names = "Genus", clinical = mrsa_clin)

## Filtering out unwanted OTUs
filt.set <- otu_filter(set, prev_cutoff = 1, ra_cutoff = 1, filter_summary = FALSE)

## Extract filtered OTU table
filt.otu.cts <- micro_otu(filt.set, table = "Genus")

## Extract filtered relative abundances table
filt.otu.ra <- micro_otu(filt.set, table = "Genus", taxa_info = ra)

}
