% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\encoding{UTF-8}
\name{bde_indicators}
\alias{bde_indicators}
\alias{bde_ind_gdp_var}
\alias{bde_ind_unemployment_rate}
\alias{bde_ind_euribor_12m_monthly}
\alias{bde_ind_euribor_12m_daily}
\alias{bde_ind_cpi_var}
\alias{bde_ind_ibex_monthly}
\alias{bde_ind_ibex_daily}
\alias{bde_ind_gdp_quarterly}
\alias{bde_ind_population}
\alias{bde_ind_ibex}
\title{Relevant Indicators of Spain}
\usage{
bde_ind_gdp_var(series_label = "GDP_YoY", ...)

bde_ind_unemployment_rate(series_label = "Unemployment_Rate", ...)

bde_ind_euribor_12m_monthly(series_label = "Euribor_12M_Monthly", ...)

bde_ind_euribor_12m_daily(series_label = "Euribor_12M_Daily", ...)

bde_ind_cpi_var(series_label = "Consumer_price_index_YoY", ...)

bde_ind_ibex_monthly(series_label = "IBEX_index_month", ...)

bde_ind_ibex_daily(series_label = "IBEX_index_day", ...)

bde_ind_gdp_quarterly(series_label = "GDP_quarterly_value", ...)

bde_ind_population(series_label = "Population_Spain", ...)
}
\arguments{
\item{series_label}{Optional. Character vector or value. Allows to specify a
custom label for the series extracted. It should have the same length than
\code{series_code}.}

\item{...}{
  Arguments passed on to \code{\link[=bde_series_load]{bde_series_load}}
  \describe{
    \item{\code{out_format}}{Defines if the format must be returned as a "long" dataset
or a "wide" dataset. Possible values are \code{"wide"} or \code{"long"}. See
\strong{Value} for Details and Section \strong{Examples}.}
    \item{\code{parse_numeric}}{Logical. If \code{TRUE} the columns would be parsed to
double (numeric) values. See \strong{Note}.}
    \item{\code{extract_metadata}}{Logical \code{TRUE/FALSE}. On \code{TRUE} the output is the
metadata of the requested series.}
    \item{\code{parse_dates}}{Logical. If \code{TRUE} the dates would be parsed using
\code{\link[=bde_parse_dates]{bde_parse_dates()}}.}
    \item{\code{update_cache}}{Logical. If \code{TRUE} the requested file would be updated on
the \code{cache_dir}.}
    \item{\code{cache_dir}}{A path to a cache directory. The directory can also be set
via options with \code{options(bde_cache_dir = "path/to/dir")}.}
    \item{\code{verbose}}{Logical \code{TRUE} or \code{FALSE}, display information useful for
debugging.}
  }}
}
\value{
A \code{tibble} with the required series.
}
\description{
Set of helper functions for downloading some of the most relevant
macroeconomic indicators of Spain.
}
\details{
This functions are convenient wrappers of \code{\link[=bde_series_load]{bde_series_load()}} referencing
specific series. Use \verb{verbose = TRUE, extract_metadata = TRUE} options
to see the specification and the source.
}
\examples{
\dontshow{if (bde_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
bde_ind_gdp_var()
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=bde_series_load]{bde_series_load()}}, \code{\link[=bde_catalog_search]{bde_catalog_search()}}
}
\concept{indicators}
