% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-model-spec.R
\name{create_model_spec}
\alias{create_model_spec}
\title{Generate Model Specification calls to \code{parsnip}}
\usage{
create_model_spec(
  .parsnip_eng = list("lm"),
  .mode = list("regression"),
  .parsnip_fns = list("linear_reg"),
  .return_tibble = TRUE
)
}
\arguments{
\item{.parsnip_eng}{The input must be a list. The default for this is set to \code{all}. This means that all
of the parsnip \strong{linear regression engines} will be used, for example \code{lm}, or
\code{glm}.}

\item{.mode}{The input must be a list. The default is 'regression'}

\item{.parsnip_fns}{The input must be a list. The default for this is set to \code{all}. This means that all
of the parsnip \strong{linear regression} functions will be used, for example \code{linear_reg()},
or \code{cubist_rules}.}

\item{.return_tibble}{The default is TRUE. FALSE will return a list object.}
}
\value{
A list or a tibble.
}
\description{
Creates a list/tibble of parsnip model specifications.
}
\details{
Creates a list/tibble of parsnip model specifications. With this function
you can generate a list/tibble output of any model specification and engine you
choose that is supported by the \code{parsnip} ecosystem.
}
\examples{
create_model_spec(
 .parsnip_eng = list("lm","glm","glmnet","cubist"),
 .parsnip_fns = list(
      "linear_reg","linear_reg","linear_reg",
      "cubist_rules"
     )
 )

create_model_spec(
 .parsnip_eng = list("lm","glm","glmnet","cubist"),
 .parsnip_fns = list(
      "linear_reg","linear_reg","linear_reg",
      "cubist_rules"
     ),
 .return_tibble = FALSE
 )

}
\seealso{
Other Model_Generator: 
\code{\link{fast_classification}()},
\code{\link{fast_regression}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Model_Generator}
