% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_ceiling.R
\name{time_ceiling}
\alias{time_ceiling}
\title{Ceiling a \code{tbl_time} object}
\usage{
time_ceiling(x, period, ...)
}
\arguments{
\item{x}{A \code{tbl_time} object.}

\item{period}{A formula or character specification used for time-based grouping.

If a formula, e.g. \code{1~year}, the formula is split and parsed to form the
grouping period. The \code{period} argument accepts a formula of the form
\code{multiple ~ period} allowing for flexible period grouping.
The following are examples:
\itemize{
\item 1 Year: \code{1~y}
\item 3 Months: \code{3~m}
\item 90 Days: \code{90~d}
}

Note that while shorthand is used above, an attempt is made to recognize
more explicit period names such as:
\itemize{
\item 2 Year: \code{2~year} / \code{2~years} / \code{2~yearly}
}

The \code{period} argument also accepts characters that are converted to their
corresponding periods. The following are accepted:
\itemize{
\item \code{"yearly"} or \code{"y"}
\item \code{"quarterly"} or \code{"q"}
\item \code{"monthly"} or \code{"m"}
\item \code{"weekly"} or \code{"w"}
\item \code{"daily"} or \code{"d"}
\item \code{"hour"} or \code{"h"}
\item \code{"minute"} or \code{"M"}
\item \code{"second"} or \code{"s"}
}}

\item{...}{Arguments passed on to \code{\link[lubridate:ceiling_date]{lubridate::ceiling_date()}}}
}
\description{
This is essentially a convenient wrapper to \code{\link[lubridate:ceiling_date]{lubridate::ceiling_date()}} that
allows ceiling of a \code{tbl_time} object using a period formula.
}
\details{
This function respects \code{\link[dplyr:group_by]{dplyr::group_by()}} groups.
}
\examples{

example_series <- create_series(~2013, 2~day)

# When you convert to a period with `side = "end"` specified,
# the highest available date in that period is chosen
example_series \%>\%
  as_period(1~m, side = "end")

# Sometimes you want to additionally ceiling that date so that all dates
# are consistent
# Note that lubridate::ceiling_date() rounds up to the next boundary,
# and does not stop at the end of the month.
example_series \%>\%
  as_period(1~m, side = "end") \%>\%
  time_ceiling(1~m)

}
