% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimpse.R
\name{glimpse}
\alias{glimpse}
\title{Get a glimpse of your data.}
\usage{
glimpse(x, width = NULL, ...)
}
\arguments{
\item{x}{An object to glimpse at.}

\item{width}{Width of output: defaults to the setting of the option
\code{tibble.width} (if finite) or the width of the console.}

\item{...}{Other arguments passed onto individual methods.}
}
\value{
x original x is (invisibly) returned, allowing \code{glimpse} to be
used within a data pipe line.
}
\description{
This is like a transposed version of print: columns run down the page,
and data runs across. This makes it possible to see every column in
a data frame. It's a little like \code{\link{str}} applied to a data frame
but it tries to show you as much data as possible. (And it always shows
the underlying data, even when applied to a remote data source.)
}
\section{S3 methods}{

\code{glimpse} is an S3 generic with a customised method for \code{tbl}s and
\code{data.frames}, and a default method that calls \code{\link{str}}.
}
\examples{
glimpse(mtcars)

if (!requireNamespace("nycflights13", quietly = TRUE))
  stop("Please install the nycflights13 package to run the rest of this example")

glimpse(nycflights13::flights)
}

