% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has-name.R
\name{has_name}
\alias{has_name}
\title{Convenience function to check presence of a named element}
\usage{
has_name(x, name)
}
\arguments{
\item{x}{A data frame or another named object}

\item{name}{Element name(s) to check}
}
\value{
A logical vector of the same length as \code{name}
}
\description{
This function returns a logical value that indicates if a data frame or
another named object contains an element with a specific name.
}
\details{
Unnamed objects are treated as if all names are empty strings.
\code{NA} input gives \code{FALSE} as output.
}
\examples{
has_name(iris, "Species")
has_name(mtcars, "gears")
}

