% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graphs.R
\name{highlall}
\alias{highlall}
\title{Highlight highest similarities overall (highlall)}
\usage{
highlall(similarity, results, quantile = 30, col = "black",
  coordinates = FALSE, add = FALSE, xlim = NULL, cex.labels = 0.8,
  main = NULL)
}
\arguments{
\item{similarity}{Similarity matrix.}

\item{results}{Results of \code{smacofSym} or a set of coordinates.}

\item{quantile}{Percentage of the highest similarities that should be drawn.
Default is \code{30}.}

\item{col}{Color of the graph. Default is \code{black}.}

\item{coordinates}{If \code{TRUE}, the input \code{results} consist of a set 
of coordinates. Default is \code{FALSE}.}

\item{add}{If \code{TRUE}, the points will be added to the existing plot.
Default is \code{FALSE}.}

\item{xlim}{Numeric vector giving the x coordinates range.}

\item{cex.labels}{Numeric value indicating font size of the labels.}

\item{main}{Title of the plot.}
}
\value{
Nothing.
}
\description{
\code{highlall} draws the highest similarities (overall) into an MDS graph.
}
\details{
This function is applicable to an MDS solution computed with the package 
'\code{smacof}' (Mair, De Leeuw, Borg, & Groenen) or a set of 
coordinates. It adds the \code{quantile} percent of highest similarities, as 
indicated by the similarity matrix \code{similarity}, to the plot of the
 respective map. The objects must occur in the same order in the results/ 
 coodinates and the similarity matrix.
}
\examples{
## Calculating an MDS using the package 'smacof' and showing the 25\% 
## highest similarities
data(SDG_coocurrence)
SDG_coocurrence <- SDG_coocurrence[,-2] # Drop second column
similarities <- simi(SDG_coocurrence, method = "as")
dissimilarities <- 1 - similarities
res <- smacof::smacofSym(dissimilarities, type = "ordinal")
highlall(similarities, res, quantile = 25, main = "25\% Highest Similarities")
}
\seealso{
\code{\link[smacof]{smacofSym}}.
}
