% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_logit_normal}
\alias{tfd_logit_normal}
\title{The Logit-Normal distribution}
\usage{
tfd_logit_normal(loc, scale, validate_args = FALSE,
  allow_nan_stats = TRUE, name = "LogitNormal")
}
\arguments{
\item{loc}{Floating point tensor; the means of the distribution(s).}

\item{scale}{loating point tensor; the stddevs of the distribution(s).
Must contain only positive values.}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{allow_nan_stats}{Logical, default TRUE. When TRUE, statistics (e.g., mean, mode, variance)
use the value NaN to indicate the result is undefined. When FALSE, an exception is raised if
one or more of the statistic's batch members are undefined.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a distribution instance.
}
\description{
The Logit-Normal distribution models positive-valued random variables whose
logit (i.e., sigmoid_inverse, i.e., \code{log(p) - log1p(-p)}) is normally
distributed with mean \code{loc} and standard deviation \code{scale}. It is
constructed as the sigmoid transformation, (i.e., \code{1 / (1 + exp(-x))}) of a
Normal distribution.
}
\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.
}
