% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{hub_sparse_text_embedding_column}
\alias{hub_sparse_text_embedding_column}
\title{Module to construct dense representations from sparse text features.}
\usage{
hub_sparse_text_embedding_column(
  key,
  module_spec,
  combiner,
  default_value,
  trainable = FALSE
)
}
\arguments{
\item{key}{A string or [feature_column](https://tensorflow.rstudio.com/tfestimators/articles/feature_columns.html)
identifying the text feature.}

\item{module_spec}{A string handle or a _ModuleSpec identifying the module.}

\item{combiner}{a string specifying reducing op for embeddings in the same Example.
Currently, 'mean', 'sqrtn', 'sum' are supported. Using `combiner = NULL` is
undefined.}

\item{default_value}{default value for Examples where the text feature is empty.
Note, it's recommended to have default_value consistent OOV tokens, in case
there was special handling of OOV in the text module. If `NULL`, the text
feature is assumed be non-empty for each Example.}

\item{trainable}{Whether or not the Module is trainable. `FALSE` by default,
meaning the pre-trained weights are frozen. This is different from the ordinary
`tf.feature_column.embedding_column()`, but that one is intended for training
from scratch.}
}
\description{
The input to this feature column is a batch of multiple strings with
arbitrary size, assuming the input is a SparseTensor.
}
\details{
This type of feature column is typically suited for modules that operate
on pre-tokenized text to produce token level embeddings which are combined
with the combiner into a text embedding. The combiner always treats the tokens
 as a bag of words rather than a sequence.

The output (i.e., transformed input layer) is a DenseTensor, with
shape [batch_size, num_embedding_dim].
}
