% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_estimator.R
\name{evaluate.tf_estimator}
\alias{evaluate.tf_estimator}
\title{Evaluate an Estimator}
\usage{
\method{evaluate}{tf_estimator}(
  object,
  input_fn,
  steps = NULL,
  checkpoint_path = NULL,
  name = NULL,
  hooks = NULL,
  simplify = TRUE,
  ...
)
}
\arguments{
\item{object}{A TensorFlow estimator.}

\item{input_fn}{An input function, typically generated by the \code{\link[=input_fn]{input_fn()}}
helper function.}

\item{steps}{The number of steps for which the model should be evaluated on
this particular \code{evaluate()} invocation. If \code{NULL} (the default), this function
will either evaluate forever, or until the supplied \code{input_fn()} has provided
all available data.}

\item{checkpoint_path}{The path to a specific model checkpoint to be used for
prediction. If \code{NULL} (the default), the latest checkpoint in \code{model_dir}
is used.}

\item{name}{Name of the evaluation if user needs to run multiple evaluations
on different data sets, such as on training data vs test data. Metrics for
different evaluations are saved in separate folders, and appear separately
in tensorboard.}

\item{hooks}{A list of \R functions, to be used as callbacks inside the
training loop. By default, \code{hook_history_saver(every_n_step = 10)} and
\code{hook_progress_bar()} will be attached if not provided to save the metrics
history and create the progress bar.}

\item{simplify}{Whether to simplify evaluation results into a \code{tibble}, as
opposed to a list. Defaults to \code{TRUE}.}

\item{...}{Optional arguments passed on to the estimator's \code{evaluate()}
method.}
}
\value{
An \R list of evaluation metrics.
}
\description{
Evaluate an estimator on input data provided by an \code{input_fn()}.
}
\details{
For each step, this method will call \code{input_fn()} to produce a single batch
of data. Evaluation continues until:
\itemize{
\item \code{steps} batches are processed, or
\item The \code{input_fn()} is exhausted of data.
}
}
\seealso{
Other custom estimator methods: 
\code{\link{estimator_spec}()},
\code{\link{estimator}()},
\code{\link{export_savedmodel.tf_estimator}()},
\code{\link{predict.tf_estimator}()},
\code{\link{train.tf_estimator}()}
}
\concept{custom estimator methods}
