% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_columns.R
\name{column_bucketized}
\alias{column_bucketized}
\title{Construct a Bucketized Column}
\usage{
column_bucketized(source_column, boundaries)
}
\arguments{
\item{source_column}{A one-dimensional dense column, as generated by \code{\link[=column_numeric]{column_numeric()}}.}

\item{boundaries}{A sorted list or list of floats specifying the boundaries.}
}
\value{
A bucketized column.
}
\description{
Construct a bucketized column, representing discretized dense input. Buckets
include the left boundary, and exclude the right boundary.
}
\section{Raises}{

\itemize{
\item ValueError: If \code{source_column} is not a numeric column, or if it is not one-dimensional.
\item ValueError: If \code{boundaries} is not a sorted list or list.
}
}

\seealso{
Other feature column constructors: \code{\link{column_categorical_weighted}},
  \code{\link{column_categorical_with_hash_bucket}},
  \code{\link{column_categorical_with_identity}},
  \code{\link{column_categorical_with_vocabulary_file}},
  \code{\link{column_categorical_with_vocabulary_list}},
  \code{\link{column_crossed}},
  \code{\link{column_embedding}},
  \code{\link{column_numeric}}, \code{\link{input_layer}}
}
