% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_methods.R
\name{dataset_enumerate}
\alias{dataset_enumerate}
\title{Enumerates the elements of this dataset}
\usage{
dataset_enumerate(dataset, start = 0L)
}
\arguments{
\item{dataset}{A tensorflow dataset}

\item{start}{An integer (coerced to a \code{tf$int64} scalar \code{tf.Tensor}),
representing the start value for enumeration.}
}
\description{
Enumerates the elements of this dataset
}
\details{
It is similar to python's \code{enumerate}, this transforms a sequence of
elements into a sequence of \code{list(index, element)}, where index is an integer
that indicates the position of the element in the sequence.
}
\examples{
\dontrun{
dataset <- tensor_slices_dataset(100:103) \%>\%
  dataset_enumerate()

iterator <- reticulate::as_iterator(dataset)
reticulate::iter_next(iterator) # list(0, 100)
reticulate::iter_next(iterator) # list(1, 101)
reticulate::iter_next(iterator) # list(2, 102)
reticulate::iter_next(iterator) # list(3, 103)
reticulate::iter_next(iterator) # NULL (iterator exhausted)
reticulate::iter_next(iterator) # NULL (iterator exhausted)
}
}
