% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{ag_while_opts}
\alias{ag_while_opts}
\title{specify \code{tf.while_loop} options}
\usage{
ag_while_opts(
  ...,
  shape_invariants = NULL,
  parallel_iterations = 10L,
  back_prop = TRUE,
  swap_memory = FALSE,
  maximum_iterations = NULL
)
}
\arguments{
\item{...}{Ignored, used to ensure all arguments supplied are named.}

\item{shape_invariants}{The shape invariants for the loop variables.}

\item{parallel_iterations}{The number of iterations allowed to run in
parallel. It must be a positive integer.}

\item{back_prop}{Whether backprop is enabled for this while loop.}

\item{swap_memory}{Whether GPU-CPU memory swap is enabled for this loop.}

\item{maximum_iterations}{Optional maximum number of iterations of the while
loop to run. If provided, the \code{cond} output is AND-ed with an additional
condition ensuring the number of iterations executed is no greater than
\code{maximum_iterations}.}
}
\value{
`NULL`` invisibly, called for it's side effect.
}
\description{
See https://www.tensorflow.org/versions/r2.0/api_docs/python/tf/while_loop
for additional details.
}
\note{
Use \code{\link[=ag_name]{ag_name()}} to supply \code{name} and \code{\link[=ag_loop_vars]{ag_loop_vars()}} to supply
\code{loop_vars} directly.

This is only applicable when autograph in graph mode, otherwise this has no
effect.
}
\examples{
\dontrun{
## use tf_function() to enter graph mode:
tf_function(autograph(function(n) {
  ag_name("silly-example")
  ag_while_opts(back_prop = FALSE)
  while(n > 0)
    n <- n - 1
}))
}
}
