% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenize_sentencepiece.R
\name{step_tokenize_sentencepiece}
\alias{step_tokenize_sentencepiece}
\title{Sentencepiece Tokenization of Character Variables}
\usage{
step_tokenize_sentencepiece(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  vocabulary_size = 1000,
  options = list(),
  res = NULL,
  skip = FALSE,
  id = rand_id("tokenize_sentencepiece")
)
}
\arguments{
\item{recipe}{A \link{recipe} object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[recipes:selections]{recipes::selections()}}
for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument. This is \code{NULL}
until the step is trained by \code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{vocabulary_size}{Integer, indicating the number of tokens in the final
vocabulary. Defaults to 1000. Highly encouraged to be tuned.}

\item{options}{A list of options passed to the tokenizer.}

\item{res}{The fitted \code{\link[sentencepiece:sentencepiece]{sentencepiece::sentencepiece()}} model tokenizer will
be stored here once this preprocessing step has be trained by
\code{\link[=prep.recipe]{prep.recipe()}}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = FALSE}.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{\link[=step_tokenize_sentencepiece]{step_tokenize_sentencepiece()}} creates a \emph{specification} of a recipe step
that will convert a character predictor into a \code{\link[=tokenlist]{token}}
variable using SentencePiece tokenization.
}
\details{
If you are running into errors, you can investigate the progress of the
compiled code by setting \code{options = list(verbose = TRUE)}. This can reveal if
sentencepiece ran correctly or not.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns \code{terms}
(the selectors or variables selected).
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
if (requireNamespace("sentencepiece", quietly = TRUE)) {
  library(recipes)
  library(modeldata)
  data(tate_text)

  tate_rec <- recipe(~., data = tate_text) \%>\%
    step_tokenize_sentencepiece(medium)

  tate_obj <- tate_rec \%>\%
    prep()

  bake(tate_obj, new_data = NULL, medium) \%>\%
    slice(1:2)

  bake(tate_obj, new_data = NULL) \%>\%
    slice(2) \%>\%
    pull(medium)

  tidy(tate_rec, number = 1)
  tidy(tate_obj, number = 1)
}
}
\seealso{
\code{\link[=step_untokenize]{step_untokenize()}} to untokenize.

Other Steps for Tokenization: 
\code{\link{step_tokenize_bpe}()},
\code{\link{step_tokenize_wordpiece}()},
\code{\link{step_tokenize}()}
}
\concept{Steps for Tokenization}
