% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_html.R
\name{read_html}
\alias{read_html}
\alias{read_xml}
\title{Read in .html Content}
\usage{
read_html(file, skip = 0, remove.empty = TRUE, trim = TRUE, ...)

read_xml(file, skip = 0, remove.empty = TRUE, trim = TRUE, ...)
}
\arguments{
\item{file}{The path to the .html file.}

\item{skip}{The number of lines to skip.}

\item{remove.empty}{logical.  If \code{TRUE} empty elements in the vector are
removed.}

\item{trim}{logical.  If \code{TRUE} the leading/training white space is
removed.}

\item{...}{Other arguments passed to \link[xml2:read_xml]{xml2::read_html()}.}
}
\value{
Returns a character vector.
}
\description{
Read in the content from a .html file.  This is generalized, reading in all
body text.  For finer control the user should utilize the \pkg{xml2} and
\pkg{rvest} packages.
}
\examples{
html_dat <- read_html(
    system.file("docs/textreadr_creed.html", package = "textreadr")
)

\dontrun{
url <- "http://www.talkstats.com/index.php"
file <- download(url)
(txt <- read_html(url))
(txt <- read_html(file))
}
}
\references{
The xpath is taken from Tony Breyal's response on StackOverflow:
\url{https://stackoverflow.com/questions/3195522/is-there-a-simple-way-in-r-to-extract-only-the-text-elements-of-an-html-page/3195926#3195926}
}
\keyword{html}
