% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textrank.R
\name{textrank_candidates_all}
\alias{textrank_candidates_all}
\title{Get all combinations of sentences}
\usage{
textrank_candidates_all(x)
}
\arguments{
\item{x}{a character vector of sentence identifiers}
}
\value{
a data.frame with 2 columns textrank_id_1 and textrank_id_2 listing up all possible combinations of \code{x}.
The columns textrank_id_1 and textrank_id_2 contain identifiers of sentences given in \code{sentence_id}.
This data.frame can be used as input in the \code{\link{textrank_sentences}} algorithm.
}
\description{
Get all combinations of sentences
}
\examples{
library(udpipe)
data(joboffer)
joboffer$textrank_id <- unique_identifier(joboffer, c("doc_id", "paragraph_id", "sentence_id"))
candidates <- textrank_candidates_all(unique(joboffer$textrank_id))
head(candidates, 50)
}
\seealso{
\code{\link{textrank_sentences}}
}
