% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_number.R
\name{replace_number}
\alias{replace_number}
\title{Replace Numbers With Text Representation}
\usage{
replace_number(x, num.paste = FALSE, remove = FALSE, ...)
}
\arguments{
\item{x}{The text variable.}

\item{num.paste}{logical.  If \code{FALSE} the elements of larger numbers are 
separated with spaces.  If \code{TRUE} the elements will be joined without 
spaces.}

\item{remove}{logical.  If \code{TRUE} numbers are removed from the text.}

\item{\ldots}{Other arguments passed to  \code{\link[english]{as.english}}}
}
\value{
Returns a vector with abbreviations replaced.
}
\description{
Replaces numeric represented numbers with words (e.g., 1001 becomes one 
thousand one).
}
\note{
The user may want to use \code{\link[textclean]{replace_ordinal}} first to 
remove ordinal number notation.  For example \code{\link[textclean]{replace_number}}
would turn "21st" into "twenty onest", whereas \code{\link[textclean]{replace_ordinal}}
would generate "twenty first".
}
\examples{
x <- c(
    NA, 
    'then .456 good', 
    'none', 
    "I like 346,457 ice cream cones.", 
    "I like 123456789 cashes.",     
    "They are 99 percent good and 45678.2345667"
)
replace_number(x)
replace_number(x, num.paste = TRUE)
replace_number(x, remove=TRUE)
}
\references{
Fox, J. (2005). Programmer's niche: How do you spell that number? 
R News. Vol. 5(1), pp. 51-55.
}
\keyword{number-to-word}

