% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_gui.R
\name{analyze_coding_density}
\alias{analyze_coding_density}
\title{Analyze coding density in text}
\usage{
analyze_coding_density(annotations)
}
\arguments{
\item{annotations}{Data frame containing annotations with columns:
\itemize{
\item start: numeric, starting position
\item end: numeric, ending position
\item code: character, code identifier
}}
}
\value{
List containing:
\itemize{
\item overall_density: Numeric value representing proportion of text covered by codes
\item dense_regions: List of vectors, each containing start and end positions
of identified dense coding regions
}
}
\description{
Calculates metrics related to coding density in the text, including overall
density and identification of densely coded regions.
}
\details{
Density is calculated as the ratio of coded text to total text length.
Dense regions are identified where consecutive annotations are close together
(within 20 characters by default).
}
\keyword{internal}
