% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-embedding.R
\name{find_rejection}
\alias{find_rejection}
\title{Find the 'rejection matrix' from a semantic vector}
\usage{
find_rejection(wv, vec)
}
\arguments{
\item{wv}{Matrix of word embedding vectors (a.k.a embedding model)
with rows as words.}

\item{vec}{Vector extracted from the embeddings}
}
\value{
A new word embedding matrix,
each row of which is rejected from vector.
}
\description{
"Reject" each word in a word embedding matrix of \eqn{D} dimension
from a vector of \eqn{D} dimensions, extracted from the same
embedding space. The vector can be a single word, or a concept
vector obtained from \code{\link[=get_centroid]{get_centroid()}}, \code{\link[=get_direction]{get_direction()}},
or \code{\link[=get_regions]{get_regions()}}.
}
