% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,lqmm-method}
\alias{extract,lqmm-method}
\alias{extract.lqmm}
\title{\code{\link{extract}} method for \code{lqmm} objects}
\usage{
\S4method{extract}{lqmm}(
  model,
  include.aic = TRUE,
  include.bic = TRUE,
  include.loglik = TRUE,
  include.nobs = TRUE,
  include.groups = TRUE,
  include.tau = FALSE,
  use.ci = FALSE,
  beside = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF
block?}

\item{include.bic}{Report the Bayesian Information Criterion (BIC) in the GOF
block?}

\item{include.loglik}{Report the log likelihood in the GOF block?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{include.groups}{Report the number of groups?}

\item{include.tau}{Report tau?}

\item{use.ci}{Report confidence intervals in the GOF block?}

\item{beside}{Arrange the model terms below each other or beside each other?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{summary} method for the object.}
}
\description{
\code{\link{extract}} method for \code{lqmm} objects created by the
\code{\link[lqmm]{lqmm}} function in the \pkg{lqmm} package.
}
